<?php

/* Lightbox-Galerie
 * bindet Abbildungen aus einem Unterordner automatisch als Lightbox-Galerie ein
 * nutzt die JavaScript-Lösungen MooTools und Slimbox
 * @version 1.1
 * @date 2008-12-21
 * @author JCHanke
 * @copyright 2008 by JCHanke, www.cmbasic.de
 * @lizenz GNU GPL
 */
 
defined('CMBASIC') or die();
$galleryYes = false;
preg_match_all("/{((galerie),(.*?))}/i", $acticon, $galeriefund);
$galeriecount = 1;
foreach ($galeriefund[1] as $galeriepara_komp) {
  $galeriepara = explode(",", $galeriepara_komp);
    
  if (!empty($galeriepara[1])) {
    $image_folder = "galerie/$galeriepara[1]";
    $galerieadd = "$galeriepara[1]";
  }

  if (!empty($galeriepara[2])) {
    $galeriebreite = "$galeriepara[2]"; 
    $galerieadd .= ",$galeriepara[2]";
  } else {
    $galeriebreite = "200";
  }
  
  if (!empty($galeriepara[3])) {
    $galeriehoehe = "$galeriepara[3]";      
    $galerieadd .= ",$galeriepara[3]";  
  } else {
    $galeriehoehe = "200";
  }

  if (phpversion() >= 5) {

    if (!file_exists($image_folder)) {
      $galeriecontent = "<p><strong>{Dieser Bilderordner existiert leider nicht!}</strong></p>";
    } else {
      $galleryYes = true;
      require_once('galerie/src/Thumbnail.class.php');
    
      // Open the sample_images subdirectory

      $dir = dir($image_folder);
      
      // Read through the files looking for images to convert, and add them to a image_html string
      while ($image = $dir->read()) {
        // Get the file extension
        $ext = explode('.',$image);
        $size = count($ext);
        // Check that it's a valid file
        if (($ext[$size-1] == 'png' || $ext[$size-1] == 'jpg' || $ext[$size-1] == 'gif')
          && !preg_match('/^thumb_/', $image)
          && $image != '.' && $image != '..') {
          // If no thumbnail exists for this image
          if ( !file_exists("$image_folder/thumb_".$image) ) {
            // Instantiate the thumbnail without scaling small images
            $tn = new Thumbnail($galeriebreite, $galeriehoehe, true, false);
            // Create the thumbnail
            $tn->loadFile("$image_folder/".$image);
            $tn->buildThumb("$image_folder/thumb_".$image);
          }
          // Titel festlegen
          $Bildtitel = $image;          
          // EXIF-Titel auslesen, falls nicht vorhanden Bildnamen verwenden
          if (function_exists('exif_read_data') && $exif = exif_read_data("$image_folder/".$image, 'IFD0')) {
            if (isset($exif['Title']) && is_string($exif['Title']) && !empty($exif['Title']) && strlen($exif['Title']) > 3) {
              $Bildtitel = $exif['Title'];
            }
          }
          if (defined("UTF8")) {
            $Bildtitel = mb_convert_encoding($Bildtitel, 'UTF-8', 'ISO-8859-1');
          }
          // Add this image to the image_html string          
          $image_html_arr["$image"] = "<div class=\"lichtkasten\" style=\"width: " . $galeriebreite . "px; height: " . 
$galeriehoehe . "px;\">" . "<a href=\"$image_folder/" . $image . "\" rel=\"lightbox[$galeriepara[1]]\" title=\"$Bildtitel\" name=\"$Bildtitel\">" . 
"<img src=\"$image_folder/thumb_" . $image."\" style=\"border: none;\"
alt=\"$Bildtitel\" title=\"$Bildtitel\" />" . "</a></div>\n";
        }
      }
      
      // alphabetisch sortieren
      if (isset($image_html_arr)) {
        ksort($image_html_arr);
        $image_html = '';
        foreach ($image_html_arr as $value) {
          $image_html .= $value;
        }
      }
      $galeriecontent = '<script type="text/javascript" language="JavaScript" src="galerie/src/mootools.js">
</script>
<script type="text/javascript" language="JavaScript" src="galerie/src/slimbox.js"></script>';    
      $galeriecontent .= $image_html . '<div class="lichtkastenende">&nbsp;</div>';
    }
  } else {
    $galeriecontent = "Das Galerieskript läuft erst ab PHP 5, Sie haben " . phpversion() . ".";  
  }
  $muster = "|{galerie,$galerieadd}|";
  $acticon = preg_replace($muster, $galeriecontent, $acticon);
  if ($galeriecount == 1) {
    $head = '<link rel="stylesheet" type="text/css" href="css/spezial/lichtkasten.css" media="screen" />';
  }
  $image_html_arr = "";
  $galeriecount++; 
}
?>