<?php
session_start();
ob_start(); // Verhindert Header-Probleme
// error_reporting(E_ALL); // PRODUKTIV = ENTFERNEN
// ini_set('display_errors', 1); // PRODUKTIV = ENTFERNEN

include "../edit/config.inc.php"; // Zugriffsdaten
include "../zugriff.inc.php"; // Verbindungsaufbau zum Datenbankserver

if (!isset($_SESSION['2fa_user'])) {
    header("Location: loginpage.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $code = trim($_POST['code']);
    $user = $_SESSION['2fa_user'];
    
    // Code aus der Datenbank abrufen
    $stmt = mysqli_prepare($conn, "SELECT code, rights FROM {$pfx}user WHERE user = ?");
    mysqli_stmt_bind_param($stmt, "s", $user);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $row = mysqli_fetch_assoc($result);
    
    if ($row && trim((string)$row['code']) == trim((string)$code)) {
        // 2FA erfolgreich
        $_SESSION[CMBASICLOG] = true;
        $_SESSION['user'] = $user;
        $_SESSION['rights'] = $row['rights'];
        
        // Code aus der Datenbank entfernen
        $stmt = mysqli_prepare($conn, "UPDATE {$pfx}user SET code = NULL WHERE user = ?");
        mysqli_stmt_bind_param($stmt, "s", $user);
        mysqli_stmt_execute($stmt);
        
        header("Location: loginpage.php");
        exit();
    } else {
        unset($_SESSION['2fa_user']);
		header("Location: loginpage.php");
        exit();
    }
}
ob_end_flush(); // Ausgabe freigeben
?>
