<?php
include_once "sessionheader.inc.php";
if (isset($_SESSION['rights']) && $_SESSION['rights'] == 4) {
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<title>SQL-Konsole</title>
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<link rel="stylesheet" type="text/css" href="css/backend.css">
</head>
<body>
<?php
  include_once "../edit/config.inc.php";
  include_once "../zugriff.inc.php";
  include_once "function.inc.php";

  echo "<h1>SQL-Konsole zur Direkteingabe der Befehle (<b>Nur für Profis!</b>)</h1>";

  if (!isset($_POST['sqlcode'])) {
      echo "<form action='sql_direct.php' method='post' enctype='multipart/form'>
<p>Bitte SQL-Befehle hier eingeben (jeder Befehl muss mit einem Semikolon abgeschlossen werden):</p>
<textarea rows='20' cols='80' name='sqlcode'></textarea>
<p><input type='submit' name='send' value='Befehle ausführen'></p>
</form>";
  } else {
      $sqlcode = trim($_POST['sqlcode']);

      if (empty($sqlcode)) {
          echo "<h2>Kein SQL-Code eingegeben.</h2>
<p><a href='javascript:history.back()'>zurück zur Befehlseingabe</a> -
<a href='sql_direct.php'>SQL-Konsole neu laden</a></p>";
      } else {
          // Zeilenumbrüche korrekt entfernen und durch Semikolon ersetzen
          $sqlcode = str_replace(array("\r\n", "\r", "\n"), " ", $sqlcode);
          // Sicherstellen, dass Befehle korrekt getrennt sind
          $commands = explode(';', $sqlcode);
          $sqlcontrol = "";
          $sqlview = "";
          $errors = "";

          foreach ($commands as $command) {
              $command = trim($command);
              if (!empty($command)) {
                  if (mysqli_query($conn, $command)) {
                      $sqlview .= "$command;\n";
                  } else {
                      $errors .= "Fehler bei Befehl: " . htmlspecialchars($command) . "<br>" . mysqli_error($conn) . "<br>";
                  }
                  $sqlcontrol .= "<small><b>Befehl</b>: " . htmlspecialchars($command) . "</small><br>";
              }
          }

          if (!empty($sqlview)) {
              echo "<h2>Datenupdate <b>erfolgreich</b>!</h2>
<p><a href='javascript:history.back()'>zurück zur Befehlseingabe</a> -
<a href='sql_direct.php'>SQL-Konsole neu laden</a></p>
<h3>Folgender Code wurde ausgeführt:</h3>
<pre class='code'>" . htmlspecialchars($sqlview) . "</pre>
<p><b>Hinweis: Es werden nur die tatsächlich ausgeführten Zeilen gezeigt!</b></p>";
          } else {
              echo "<h2>Datenupdate <b>nicht</b> erfolgreich!</h2>
<p><a href='javascript:history.back()'>zurück zur Befehlseingabe</a> -
<a href='sql_direct.php'>SQL-Konsole neu laden</a></p>
<h3>Folgender Code wurde übergeben:</h3>
<pre class='code'>" . htmlspecialchars($sqlcode) . "</pre>
<p>Fehler: $errors</p>";
          }

          echo "<h4>Multibefehl-Check:</h4>\n<div>$sqlcontrol</div>";

          mysqli_close($conn);
      }
  }
} else {
  include "umleitung.php";
}
?>
</body>
</html>
