<?php
if (isset($_POST['submit'])) {
    $fehler = false;
    $fehlertext = "";

    // Sicherstellen, dass alle Felder existieren
    $From = isset($_POST['From']) ? trim($_POST['From']) : "";
    $To = isset($_POST['To']) ? trim($_POST['To']) : "";
    $Subject = isset($_POST['Subject']) ? trim($_POST['Subject']) : "";
    $Msg = isset($_POST['Msg']) ? trim($_POST['Msg']) : "";

    // E-Mail-Validierung mit filter_var()
    if (empty($From)) {
        $fehler = true;
        $fehlertext .= "Der Absender fehlt!<br>\n";
    } elseif (!filter_var($From, FILTER_VALIDATE_EMAIL)) {
        $fehler = true;
        $fehlertext .= "Absender-Adresse ungültig!<br>\n";
    }

    if (empty($To)) {
        $fehler = true;
        $fehlertext .= "Der Empfänger fehlt!<br>\n";
    } elseif (!filter_var($To, FILTER_VALIDATE_EMAIL)) {
        $fehler = true;
        $fehlertext .= "Empfänger-Adresse ungültig!<br>\n";
    }

    if (empty($Subject) || strlen($Subject) < 3) {
        $fehler = true;
        $fehlertext .= "Der Betreff ist zu kurz!<br>\n";
    }

    if (empty($Msg) || strlen($Msg) < 3) {
        $fehler = true;
        $fehlertext .= "Die Botschaft ist zu kurz!<br>\n";
    }

  if ($fehler) {
    echo "<p>$fehlertext</p>";
  } else {
    include "mailclass/htmlMimeMail.php"; // Hayes-Klasse includen
    $mail = new htmlMimeMail();
    $text = $Msg; // Als Text speichern
    $mail->setText($text); // Botschaft vorbereiten
    $mail->setFrom("$From");
    $mail->setSubject("$Subject");
    if ($result = $mail->send(array("$To"))) { // Versenden
      echo "<p class='success'>Danke! Die Botschaft wurde weitergeleitet!</p>\n";
      $From = "";
      $Subject = "";
      $Msg = "";
    } else {
      echo "<p class='nosuccess'>Leider gab es einen Sendefehler!</p>\n";
    } 
  } 
} 
?>