<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
include "mailclass/htmlMimeMail.php"; // Hayes-Klasse includen
if (!isset($_SESSION['login_attempts'])) {
	$_SESSION['login_attempts'] = 0;
}

if (!empty($_POST['user']) && !empty($_POST['pw'])) {
    if (SID != "") {
        $status_no = "<h3>Bitte schalten Sie Cookies ein!</h3>";
    } else {
        $user = trim($_POST['user']);
        $pw = trim($_POST['pw']);
        
        $stmt = mysqli_prepare($conn, "SELECT user, pw, rights, email FROM {$pfx}user WHERE user = ?");
        mysqli_stmt_bind_param($stmt, "s", $user);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        
        if ($loginrow = mysqli_fetch_assoc($result)) {
            $authenticated = false;
            if (strlen($loginrow['pw']) == 32) {
                if (md5($pw) == $loginrow['pw']) {
                    $authenticated = true;
                }
            } else {
                if (password_verify($pw, $loginrow['pw'])) {
                    $authenticated = true;
                }
            }
            
            if ($authenticated) {
                // Prüfen, ob eine gültige E-Mail-Adresse existiert
                if (!empty($loginrow['email']) && filter_var($loginrow['email'], FILTER_VALIDATE_EMAIL)) {
                    // 2FA-Code generieren und speichern
                    $code = str_pad(rand(0, 999999), 6, "0", STR_PAD_LEFT);
                    $stmt = mysqli_prepare($conn, "UPDATE {$pfx}user SET code = ? WHERE user = ?");
                    mysqli_stmt_bind_param($stmt, "ss", $code, $user);
                    mysqli_stmt_execute($stmt);
                    
                    // 2FA-Code per E-Mail senden mit htmlMimeMail
                    $mail = new htmlMimeMail();
                    $message = "Ihr 2FA-Code lautet: " . $code . "\nGeben Sie diesen Code bitte ein.";
                    $message = utf8_decode($message); // Umlaute entschärfen
                    $mail->setText($message);
                    $mail->setFrom("no-reply@cmbasic.de");
                    $mail->setSubject("Ihr Bestätigungscode");
                    
                    if ($mail->send(array($loginrow['email']))) {
                        $_SESSION['2fa_user'] = $user;
                        header("Location: 2fa.php");
                        exit();
                    } else {
                        $status_no = "<h2>Fehler beim Versenden der E-Mail.</h2>";
                    }
                } else {
                    // Kein 2FA erforderlich, da keine gültige E-Mail
                    $_SESSION[CMBASICLOG] = true;
                    $_SESSION['user'] = $user;
                    $_SESSION['rights'] = $loginrow['rights'];
                    $status_yes = "<h2>Anmelden erfolgreich!</h2>
                    <p>Sie sind angemeldet als <strong>$user</strong>! - 
                    <a href='loginpage.php?logoff=1'> 
                    Abmelden?</a></p>";
                }
            }
        }
		$_SESSION['login_attempts'] += 1;
        $status_no = "<h2>Anmeldedaten nicht korrekt!</h2>";
    }
}
?>
